<?php



/**
 * Se encarga de la generaciÃ³n de documentos imprimibles en el sistema
 * Contiene una configuraciÃ³n de cada tipo de documento siguiendo la convenciÃ³n
 * de que la plantilla html corresponde al codigo del documento.
 * Genera Html basado en plantilla y se puede genear pdfs.
 * Utiliza una modificaciÃ³n de la maquinaria de plantillas Razor para el Yii y
 * una clase de plantillas en php mismo que evalua las variables y devuelve el html
 * @author vsayajin
 * @package components.documentos
 */
class GeneradorDocumentos {

	/**
	 * Ruta a la bilbioteca TCPDF
	 * @var strin
	 */
	protected $lista = array();
	protected $repository;

	public function __construct() {
              include_once('RepositorioPlantillas.php');
		$this->repository = new RepositorioPlantillas();
	}

	/**
	 * Crea el contexto de variables que se pasaran a la plantilla para evaluar.
	 * TODO: se deberia hacer que de acuerdo a la plantila, se extraigan las variables y de ahi
	 * solo se pongan las que sean necesarias.
	 * @param <type> $sol
	 * @return <type>
	 */
	public function crearContexto($variables=array(),$tipo='') {
                include_once("TemplateUtils.php");
                $ctx = array();
                
                $ctx['datos']['fecha'] = date("Y-m-d");
                $ctx['datos']['nombre'] = $variables['nombre'];
                $ctx['datos']['apellido'] = $variables['apellido'];
                $ctx['datos']['empresa'] = $variables['empresa'];
                $ctx['datos']['ciudad'] = $variables['ciudad'];
                $ctx['datos']['direccion'] = $variables['direccion'];
                $ctx['datos']['correo'] = $variables['correo'];
                $ctx['datos']['telefono'] = $variables['codigotelefono'].' '.$variables['telefono'];
                $ctx['datos']['celular'] = $variables['celular'];




                    $ctx['datos']['plan'] = $variables['plan'];
                    $ctx['datos']['monto'] = $variables['montotexto'];
                    $ctx['datos']['deducible'] = $variables['deducible'];
                    $ctx['datos']['cs'] = $variables['cs'];


                    $cont=0;
                    $cont1=0;
                    $vector = array();

                    for($i=0;$i<count($variables['nombreDependiente']);$i++){
                        $vector[$cont1][$cont] = $variables['nombreDependiente'][$i];
                        $cont++;
                        $vector[$cont1][$cont] = $variables['parentescoDependiente'][$i];
                        $cont++;
                        $vector[$cont1][$cont] = $variables['sexoDependiente'][$i];
                        $cont++;
                        $vector[$cont1][$cont] = $variables['edadDependiente'][$i];
                        $cont=0;
                        $cont1++;
                    }
                    $ctx['datos']['dependiente'] = $vector;



                
                $ctx['datos']['calculo'] = $variables['calculo'];

                $ctx['util'] = new TemplateUtil();
                
                return $ctx;
	}

	/**
	 * Procesa una plantilla de documentos y devuelve el html generado.
	 * TODO: mejorar el reemplazo de variables al estilo pull
	 * @param string $tipo
	 * @param Solicitud $sol
	 * @param array $datos datos adicionales
	 * @return string Html generado
	 */
	public function generar($variables=array(),$tipo) {

        include_once('extensions/RazorViewRenderer.php');
        include_once('PHPTemplate.php');
		setlocale(LC_TIME, "es_ES");

        //USERS

		$content = $this->repository->contenidoPlantilla($tipo);

		$source = str_replace('-&gt;', '->', $content); // corregir ->
		$engine = new RazorViewRenderer();
		$text = $engine->generateContent($source);

		$ctx = $this->crearContexto($variables,$tipo);

		$tpl = new PHPTemplate();
		$tpl->vars = $ctx;
		$res = $tpl->evalCode($text);
        file_put_contents('plantillaTemporal.html', $res);
		return $res;

	}


    public function generarAdmin($variables=array(),$tipo) {

        include_once('extensions/RazorViewRenderer.php');
        include_once('PHPTemplate.php');
        setlocale(LC_TIME, "es_ES");

        //USERS
        $tipoAdmin = "Admin";
        $content = $this->repository->contenidoPlantilla($tipoAdmin);

        $source = str_replace('-&gt;', '->', $content); // corregir ->
        $engine = new RazorViewRenderer();
        $text = $engine->generateContent($source);

        $ctx = $this->crearContexto($variables,$tipo);

        $tpl = new PHPTemplate();
        $tpl->vars = $ctx;
        $res = $tpl->evalCode($text);
        file_put_contents('plantillaTemporalAdmin.html', $res);
        return $res;

    }



}

?>
